﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel.Activation;
using System.ServiceModel;
using System.Web;
using ServiceData.Simple;
using System.Runtime.Serialization;

namespace ServiceCommunication.SimpleService
{
    #region Service Interface

    [ServiceContract]
    [ServiceKnownType(typeof(Customer))]
    internal interface ISimpleWCFService
    {
        [OperationContract]
        [CommunicationSupport.JsonMessageClass(typeof(CustomerSaveCustomer))]
        Customer SaveCustomer(Customer customer);
        [OperationContract]
        [CommunicationSupport.JsonMessageClass(typeof(CustomerLookupCustomer))]
        Customer LookupCustomer(int customerId);
    }

    #endregion

    #region Json Message Classes

    [DataContract]
    public class CustomerSaveCustomer
    {
        [DataMember]
        public Customer customer { get; set; }
    }

    [DataContract]
    public class CustomerLookupCustomer
    {
        [DataMember]
        public int customerId { get; set; }
    }

    #endregion

    #region Service Implementation

    //[ServiceContract]
    [AspNetCompatibilityRequirements(RequirementsMode = AspNetCompatibilityRequirementsMode.Allowed)]
    internal class SimpleWCFService : ISimpleWCFService
    {
        #region ISimpleWCFService Members

        //[OperationContract]
        //[CommunicationSupport.JsonMessageClass(typeof(CustomerSaveCustomer))]
        public Customer SaveCustomer(Customer customer)
        {
            if (customer.CustomerId == 0)
            {
                Random random = new Random();
                customer.CustomerId = random.Next();
            }
            HttpContext.Current.Session.Add(customer.CustomerId.ToString(), customer);
            return customer;
        }
        //[OperationContract]
        //[CommunicationSupport.JsonMessageClass(typeof(CustomerLookupCustomer))]
        public Customer LookupCustomer(int customerId)
        {
            object customer = null;
            customer = HttpContext.Current.Session[customerId.ToString()];
            return customer as Customer;
        }

        #endregion
    }

    #endregion
}
